cd ..
cd ".\6. Logfiles"
log using "0 Preliminaries", replace
cd ..
cd ".\1. Dofiles"
/******************************************************************/
/******************************************************************/
/**** 	0. Preliminaries										***/
/******************************************************************/
/******************************************************************/
	
	* Define settings
	clear all
	set more off
	set maxvar 32000
	set matsize 11000
	set seed 1
	
	* Set time dimension of panel dataset
	global startyear = 1940
	
	* Identify the growth predictors used in the synthetic control algorithm
	global SCM_covariates baseline_gdpcap open lpop market_potential bdeaths educ health
	
	* Set number of clusters for the parallel computation procedure
	global numberofclusters = 25
	
	* Define spatial constraints for robustness checks
	
		* Set spatial constraint for robustness check 1
		global spatial_constraint = 2000 		// Maximal distance between capital cities (in km) for inclusion in spatial sample of control countries (robustness check 1)
		
		* Set time constraint for robustness check 2
		global time_constraint = 30				// Minimal number of independence years for inclusion in conservative sample of control countries (robustness check 2)
		
		* Set spatial constraint for robustness check 3
		global spatial_constraint_2 = 4000 		// Minimal distance between capital cities (in km) for inclusion in spatial sample of control countries (robustness check 3)

	* Define number of bootstrap repetitions for bootstrapped standard errors
	
			* Aggregate independence dividends
			global firststepreps 750	// # of replications to compute bootstrapped standard errors for the aggregate independence dividends (part 2.)
			
			* Second-step results
			global secondstepreps 750	// # of replications to compute bootstrapped standard errors for the multivariate analysis of independence dividends (part 3.3.)

log close

cd ..
cd ".\6. Logfiles"
cap log using "1 Data Construction", replace
cd ..
cd ".\1. Dofiles"

/******************************************************************/
/******************************************************************/
/**** 	1. Data, descriptive statistics and general model		***/
/******************************************************************/
/******************************************************************/

/* 1.1. Collect raw data */
do "1.1. Data collection.do"

/* 1.2. Load master data file */
//This file contains all the country & region identifiers which will be used to merge data from all sources
do "1.2. Master data file.do"

/* 1.3. Add relevant data */
foreach var in "Independence dates" "Population + surface area" "GDP per capita" "Human capital" "Trade openness" "Institutions" "Political & macroeconomic stability" "Membership dummies" {
	do "1.3. Data construction - `var'.do"
	}

* 1.3.1. Drop all irrelevant identifiers
	drop cntrycode_*
	
/* 1.4. Summary statistics & Preliminary analysis */

	* Table 1
	do "1.4. Data implications - Summary.do"

	* Figures 1a & 1b
	do "1.4. Data implications - preliminary analysis.do"
	
/* 1.5. Data sources */

	* Table 2
	do "1.5. Data sources - Summary.do"
		
	* Online appendix table O1
	do "1.5. Data sources - Details.do"

/* 1.5. Save master data file */
qui {
cd ..
cd ".\4. Master data"

	* Keep relevant variables
	keep cntrycode year cntry region independence_years spring surface lsurface mother_cntry mother_country_name pop popshare popdens lpop baseline_gdpcap baseline_lgdpcap alternative_gdpcap alternative_lgdpcap baseline_GDP alternative_GDP market_potential educ health lhealth open lopen dem bdeaths lbdeaths crisis_tally crisis EU_dummy soviet_dummy yugoslav_dummy referendum_dummy NATO_dummy AU_dummy ASEAN_dummy doil
	
	* Keep relevant years
	drop if year < $startyear
	
	* Save master data
	save master_data, replace
	cd ..
	}

log close
cd ".\6. Logfiles"
cap log using "2 Semi-parametric_estimation (first step)", replace
cd ..

cd ".\1. Dofiles"

/******************************************************/
/******************************************************/
/**** 	2. Semi-Parametric analysis (first step)	***/
/******************************************************/
/******************************************************/

/* 2.0. Load master data */
qui {
cd ..
cd ".\4. Master data"
clear all
use master_data
sort cntrycode year
cd ..
cd ".\1. Dofiles"
}

/* 2.1. Construct necessary data (drop unnecessary entities, generate necessary variables) */
do "2.1. Construction data.do"

/* 2.2. Construct synthetic control countries: run algorithm */
do "2.2.a. Synthetic control algorithm - main simulation.do"
do "2.2.c. Synthetic control algorithm - robustness simulation 1.do"
do "2.2.e. Synthetic control algorithm - robustness simulation 2.do"
do "2.2.g. Synthetic control algorithm - robustness simulation 3.do"

/* 2.3. Construct synthetic control countries: estimate raw independence dividends */
do "2.3.a. Synthetic control algorithm - Identify incorporated NICs.do"
do "2.3.b. Synthetic control algorithm - Country-specific independence dividends.do"

/* 2.4. Baseline results */
do "2.4.a. Synthetic control algorithm - Motivating example.do"
do "2.4.b. Synthetic control algorithm - Baseline results.do"

/* 2.5. Bias-correction and inference */

	/* 2.5.1. First step: trend-demeaned estimates */
	do "2.5.a. Synthetic control algorithm - Motivating example (2).do"
	do "2.5.b. Synthetic control algorithm - Trend-demeaned results.do"

	/* 2.5.2. Second step: p-values */
	do "2.6.a. Synthetic control algorithm - Motivating example (3).do"
	do "2.6.b. Synthetic control algorithm - Compute country-specific and aggregate p-values.do"

	/* 2.5.3. Third step: confidence intervals */
	do "2.7.a. Synthetic control algorithm - Motivating example (4).do"
	do "2.7.b. Synthetic control algorithm - Compute country-specific & aggregate confidence intervals.do"

/* 2.6. Robustness checks */
do "2.8.a. Synthetic control algorithm - Country-specific independence dividends (robustness checks).do"
do "2.8.b. Synthetic control algorithm - Different weighting schemes.do"
do "2.8.c. Synthetic control algorithm - Purging transition effects.do"

/* 2.7. Selected results */
do "2.9. Synthetic control algorithm - Selected results.do"
do "2.10. Synthetic control algorithm - Export country-specific estimates.do"
log close

cd ..
cd ".\6. Logfiles"
log using "3 Semi-parametric_estimation (second step)", replace
cd ..
cd ".\1. Dofiles"
/******************************************************/
/******************************************************/
/**** 	3. Semi-Parametric analysis (second step)	***/
/******************************************************/
/******************************************************/

do "3.1. Second-step - Data collection.do"
do "3.2. Second-step - Univariate analysis.do"
do "3.3. Second-step - Multivariate analysis.do"
log close

cd ..
cd ".\6. Logfiles"
log using "4 Data availability ", replace
cd ..
cd ".\1. Dofiles"
/******************************************************/
/******************************************************/
/**** 	4. Report available NICs and characteristics **/
/******************************************************/
/******************************************************/
	
do "4. Identify NICs and data availability.do"
log close
